package cn.com.duiba.activity.center.api.dto.app_survey;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 问券题目
 *
 * @author fja
 * @since 2022-07-21 18:04:04
 */
public class AppSurveyQuestionDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 问券Id
     */
    private Long surveyId;

    /**
     * 题目类型 1-单选，2-多选，3-填空，4-评价题
     */
    private Integer questionType;


    /**
     * 题目描述
     */
    private String questionDescription;


    /**
     * 题目是否必填, 0-非必填，1必填
     */
    private Integer questionRequired;

    /**
     * 评分题配置，json数组字符串
     */
    private String rateQuestionConfig;

    /**
     * 扩展
     */
    private String extraJson;

    /**
     * 题目选项列表
     */
    private List<AppSurveyOptionDto> optionConfigList;


    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 更新时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getSurveyId() {
        return surveyId;
    }

    public void setSurveyId(Long surveyId) {
        this.surveyId = surveyId;
    }

    public Integer getQuestionType() {
        return questionType;
    }

    public void setQuestionType(Integer questionType) {
        this.questionType = questionType;
    }

    public String getQuestionDescription() {
        return questionDescription;
    }

    public void setQuestionDescription(String questionDescription) {
        this.questionDescription = questionDescription;
    }

    public Integer getQuestionRequired() {
        return questionRequired;
    }

    public void setQuestionRequired(Integer questionRequired) {
        this.questionRequired = questionRequired;
    }

    public String getRateQuestionConfig() {
        return rateQuestionConfig;
    }

    public void setRateQuestionConfig(String rateQuestionConfig) {
        this.rateQuestionConfig = rateQuestionConfig;
    }

    public String getExtraJson() {
        return extraJson;
    }

    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }

    public List<AppSurveyOptionDto> getOptionConfigList() {
        return optionConfigList;
    }

    public void setOptionConfigList(List<AppSurveyOptionDto> optionConfigList) {
        this.optionConfigList = optionConfigList;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}

