package cn.com.duiba.activity.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * @Author: fss
 * @Date: 2022/11/23 11
 * @Description: 此枚举之前的没有包含，比如天降好礼类型的是在web
 */
public enum PoolTypeEnum {

    /**
     * 目前只针对圆形、方形大转盘
     */
    HUNDRED_PERCENT_POOL("HUNDRED_PERCENT_POOL", "百分百奖池"),
    ;

    private String poolType;

    private String desc;

    private PoolTypeEnum(String poolType, String desc) {
        this.poolType = poolType;
        this.desc = desc;
    }

    public static PoolTypeEnum getByPoolType(String poolType) {
        for (PoolTypeEnum enumVal : PoolTypeEnum.values()) {
            if (StringUtils.equals(poolType, enumVal.getPoolType())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getDesc() {
        return desc;
    }

    public String getPoolType() {
        return poolType;
    }
}
