package cn.com.duiba.activity.center.api.enums.pyramidspread;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by HePeng on 2019/04/25 10:11.
 */
public enum SpreadConsumerBonusTypeEnum {
    TYPE_NEW(0, "新人奖励红包"),
    TYPE_INVITE(1, "邀请奖励红包"),
    TYPE_LEVEL_TWO_CUT(2, "二级抽成红包"),
    TYPE_LEVEL_THREE_CUT(3, "三级抽成红包"),
    ;

    private static final ImmutableMap<Integer, SpreadConsumerBonusTypeEnum> ALL_MAP;
    static {
        Map<Integer, SpreadConsumerBonusTypeEnum> temp = Maps.newHashMap();
        for(SpreadConsumerBonusTypeEnum enumVal: SpreadConsumerBonusTypeEnum.values()) {
            temp.put(enumVal.getType(), enumVal);
        }
        ALL_MAP = ImmutableMap.copyOf(temp);
    }

    public static SpreadConsumerBonusTypeEnum getByType(Integer type) {
        return ALL_MAP.get(type);
    }

    private Integer type;
    private String desc;

    SpreadConsumerBonusTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
