package cn.com.duiba.activity.center.api.exception;

/**
 * 活动中心业务异常
 * Created by xiaoxuda on 2017/4/20.
 */
public class ActivityCenterException extends RuntimeException{
    private static final long serialVersionUID = -6352918103285006028L;

    private final String errCode;

    /**
     * 继承父类
     */
    public ActivityCenterException(){
        super();
        errCode = null;
    }

    /**
     * 继承父类
     * @param message
     */
    public ActivityCenterException(String message){
        super(message);
        errCode = null;
    }

    public ActivityCenterException(String errCode, String message){
        super(message);
        this.errCode = errCode;
    }

    /**
     * 继承父类
     * @param e
     */
    public ActivityCenterException(Exception e){
        super(e);
        errCode = null;
    }

    public String getErrCode() {
        return errCode;
    }

}
