package cn.com.duiba.activity.center.api.enums.happycodenew;

/**
 * Created by Liugq on 2019/3/29.
 * 开心码积分兑换的状态
 */
public enum HappyExchangeStatusEnum {
    EXCHANGE_STATUS_INIT(0, "初始化"),
    EXCHANGE_STATUS_SUC(1, "处理成功"),
    EXCHANGE_STATUS_FAIL(2, "处理失败"),
    ;


    private Integer code;
    private String desc;

    HappyExchangeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static HappyExchangeStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (HappyExchangeStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
