package cn.com.duiba.activity.center.api.dto.bargain;

import java.io.Serializable;
import java.util.Date;

/**
 * @author author
 */
public class BargainItemInfoDto implements Serializable {

    private static final long serialVersionUID = 3786279984365382919L;
    /**
     * 主键
     * 物理主键
     * isNullAble:0
     */
    private Long id;

    /**
     * 砍价活动id,tb_bargain_activity_info.id
     * isNullAble:0
     */
    private Long bargainActivityId;

    /**
     * 砍价商品id,来源item.id
     * isNullAble:0
     */
    private Long itemId;

    /**
     * 砍价规则id,来源tb_bargain_rule_info.id
     * isNullAble:0
     */
    private Long bargainRuleId;

    /**
     * 商品图片url
     * isNullAble:1
     */
    private String imageUrl;

    /**
     * 参与商品数量
     * isNullAble:0
     */
    private Integer remaining;

    /**
     * 砍价时长(秒)
     * isNullAble:0
     */
    private Integer bargainDuration;

    /**
     * 作弊基数
     * isNullAble:0
     */
    private Integer cheatBase;

    /**
     * 作弊倍数
     * isNullAble:0
     */
    private Integer cheatMultiple;

    /**
     * 砍价成功数量
     */
    private Integer completedCount;

    /**
     * 删除标志位(0-正常 1-删除)
     * isNullAble:0,defaultVal:0
     *
     * @see cn.com.duiba.activity.center.api.enums.DeletedEnum
     */
    private Integer deleted;

    /**
     * 修改时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 创建时间
     * isNullAble:0,defaultVal:CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getBargainActivityId() {
        return bargainActivityId;
    }

    public void setBargainActivityId(Long bargainActivityId) {
        this.bargainActivityId = bargainActivityId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getCompletedCount() {
        return completedCount;
    }

    public void setCompletedCount(Integer completedCount) {
        this.completedCount = completedCount;
    }

    public Long getBargainRuleId() {
        return bargainRuleId;
    }

    public void setBargainRuleId(Long bargainRuleId) {
        this.bargainRuleId = bargainRuleId;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public Integer getRemaining() {
        return remaining;
    }

    public void setRemaining(Integer remaining) {
        this.remaining = remaining;
    }

    public Integer getBargainDuration() {
        return bargainDuration;
    }

    public void setBargainDuration(Integer bargainDuration) {
        this.bargainDuration = bargainDuration;
    }

    public Integer getCheatBase() {
        return cheatBase;
    }

    public void setCheatBase(Integer cheatBase) {
        this.cheatBase = cheatBase;
    }

    public Integer getCheatMultiple() {
        return cheatMultiple;
    }

    public void setCheatMultiple(Integer cheatMultiple) {
        this.cheatMultiple = cheatMultiple;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
}
