package cn.com.duiba.activity.center.api.dto.sign.system;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.com.duiba.activity.center.api.enums.SignCalendarResponseTypeEnum;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;

/**
 * Created by sty on 2017/5/31.
 */
public class SignCalendarRuleDto extends SignRuleDto implements Serializable {

    private static final long serialVersionUID = 8860667815569018687L;

    public static final String KEY_EXTRA_BONUS = "extraBonus";

    private static final Logger logger = LoggerFactory.getLogger(SignCalendarRuleDto.class);
    /**
     * 签到日期
     */
    private String signDate;
    /**
     * 是否自定义图标
     */
    private Boolean iconCustom;
    /**
     * 自定义图标
     */
    private String iconImage;
    /**
     * 日期按钮响应类型
     */
    private SignCalendarResponseTypeEnum responseType;
    /**
     * 气泡提示语
     */
    private String prompt;
    /**
     * 跳转链接
     */
    private String skipUrl;

    /**
     * 预告代码，查询时需要调用独立接口读取
     */
    private String html;

    /**
     * 链接组,多链接模式
     */
    private List<SignLinkDto> linkGroup;

    private Date gmtCreate;

    private Date gmtModified;
    /**
     * 额外字段
     */
    private JSONObject extJson;


    public String getSignDate() {
        return signDate;
    }

    public void setSignDate(String signDate) {
        this.signDate = signDate;
    }

    public Boolean getIconCustom() {
        return iconCustom;
    }

    public void setIconCustom(Boolean iconCustom) {
        this.iconCustom = iconCustom;
    }

    public String getIconImage() {
        return iconImage;
    }

    public void setIconImage(String iconImage) {
        this.iconImage = iconImage;
    }

    public SignCalendarResponseTypeEnum getResponseType() {
        return responseType;
    }

    public void setResponseType(SignCalendarResponseTypeEnum responseType) {
        this.responseType = responseType;
    }

    public String getPrompt() {
        return prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getSkipUrl() {
        return skipUrl;
    }

    public void setSkipUrl(String skipUrl) {
        this.skipUrl = skipUrl;
    }

    public String getHtml() {
        return html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public List<SignLinkDto> getLinkGroup() {
        return linkGroup;
    }

    public void setLinkGroup(List<SignLinkDto> linkGroup) {
        this.linkGroup = linkGroup;
    }

    public static List<SignLinkDto> getLinkGroupList(String links){
        List<SignLinkDto> linkGroup= Lists.newArrayList();
        if(StringUtils.isBlank(links)){
            return linkGroup;
        }
        try{
           return JSONArray.parseArray(links,SignLinkDto.class);
        }catch(Exception e){
            logger.warn("转化SignLinkDto list出错",e);
            return linkGroup;
        }
    }

    public static String transferToLinkGroupArray( List<SignLinkDto> links){
        JSONArray linksArray=new JSONArray();
        if(links==null){
            return linksArray.toString();
        }
        return JSONArray.toJSONString(links);
    }

    public JSONObject getExtJson() {
        return extJson;
    }

    public void setExtJson(JSONObject extJson) {
        this.extJson = extJson;
    }

    public void putToExtra(String key, Object val){
        if(extJson == null){
            extJson = new JSONObject();
        }
        extJson.put(key,val);
    }

    public void removeFromExtra(String key){
        if(extJson == null){
            return;
        }
        extJson.remove(key);
    }

    public Object getFromExtra(String key){
        if(extJson == null){
            return null;
        }
        return extJson.get(key);
    }

    /**
     * 提取额外奖励信息
     * @return
     */
    public ExtraSignBonusDto getExtraSignBonus(){
        if(extJson == null){
            return null;
        }
        return extJson.getObject(KEY_EXTRA_BONUS, ExtraSignBonusDto.class);
    }

    public boolean isOpenExtraBonus(){
        ExtraSignBonusDto extraSignBonusDto=getExtraSignBonus();
        if(extraSignBonusDto==null||extraSignBonusDto.getOpenStatus()==null){
            return false;
        }
        return extraSignBonusDto.getOpenStatus();
    }
}
