package cn.com.duiba.activity.center.api.enums.singleAward;

import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/6/8 11:10
 */
public enum ActivityRecordStatusEnum {
    CREATE("create", "创建"),
    WAIT_PAY("wait_pay", "待支付"),
    NO_PAY("no_pay", "无需支付"),
    PAYING("paying", "支付中"),
    PAY_SUCCESS("pay_success", "支付成功"),
    PAY_FAIL("pay_fail", "支付失败"),
    REFUNDING("refunding", "退款中"),
    REFUND_SUCCESS("refund_success", "退款成功"),
    REFUND_FAIL("refund_fail", "退款失败"),
    PAY_TIMEOUT("pay_timeout", "支付超时"),
    WAIT_RECEIVE("wait_receive", "待领取"),
    RECEIVE_SUCCESS("receive_success", "领取成功"),
    RECEIVE_FAIL("receive_fail", "领取失败"),
    ;

    private String code;

    private String desc;

    ActivityRecordStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityRecordStatusEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        ActivityRecordStatusEnum[] values = ActivityRecordStatusEnum.values();
        for (ActivityRecordStatusEnum value : values) {
            if (Objects.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
