package cn.com.duiba.activity.center.api.remoteservice.offlineissuance;

import cn.com.duiba.activity.center.api.domain.dto.offlineissuance.OfflineIssuanceMechanismGoodsDto;
import java.util.List;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteOfflineIssuanceMechanismGoodsService {

	Integer save(OfflineIssuanceMechanismGoodsDto offlineIssuanceMechanismGoodsDto) throws BizException;

    void deleteById(Long id) throws BizException;

    void deleteBatchByIds(List<Long> ids) throws BizException;

    Integer updateById(OfflineIssuanceMechanismGoodsDto offlineIssuanceMechanismGoodsDto) throws BizException;

    OfflineIssuanceMechanismGoodsDto getById(Long id) throws BizException;

    List<OfflineIssuanceMechanismGoodsDto> listByIds(List<Long> ids) throws BizException;

    /**
     * 根据商品id批量查询
     * @param appItemIds
     * @return
     */
    List<OfflineIssuanceMechanismGoodsDto> listByAppItemIds(List<Long> appItemIds);

    /**
     * 根据机构号分页查询
     * @param appId
     * @param mechanismNo
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<OfflineIssuanceMechanismGoodsDto> listByPage(Long appId,String mechanismNo, Integer pageNo, Integer pageSize);

    /**
     * 添加机构商品
     * @param offlineIssuanceMechanismGoodsDtoList
     * @return
     */
    Integer addMechanismGoods(List<OfflineIssuanceMechanismGoodsDto> offlineIssuanceMechanismGoodsDtoList);

    /**
     * 根据appId、机构号、appItemId查询
     * @param appId
     * @param mechanismNo
     * @param appItemId
     * @return
     */
    OfflineIssuanceMechanismGoodsDto getByAppIdAndNoAndAppItemId(Long appId,String mechanismNo, Long appItemId);

}
