package cn.com.duiba.activity.center.api.remoteservice.openredpacket;

import cn.com.duiba.activity.center.api.dto.openredpacket.OpenRedPacketConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @Author: lufeng
 * @Description: 拆红包活动配置接口
 * @Date: Created in 2019/4/26
 */
@AdvancedFeignClient
public interface RemoteOpenRedPacketConfigService {

    /**
     * 通过主键id获取活动配置信息
     * @param id
     * @return
     */
    OpenRedPacketConfigDto queryOrpConfig(Long id);

    /**
     * 新建活动配置信息
     */
    Long createOrpConfig(OpenRedPacketConfigDto dto);

    /**
     * 保存活动配置信息
     */
    Boolean updateOrpConfig(OpenRedPacketConfigDto dto);

    /**
     * 结束活动
     */
    void endActivity(Long configId);
}
