package cn.com.duiba.activity.center.api.dto.hdtool;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by zzy on 2017/3/15.
 */
public class HdtoolOrdersExceptionQueryDto implements Serializable {
    private static final long serialVersionUID = 3571546308741736311L;

    public static final int ExchangeStatusWait = HdtoolOrdersExceptionDto.ExchangeStatusWait;          // 待领取
    public static final int ExchangeStatusFail = HdtoolOrdersExceptionDto.ExchangeStatusFail;          // 领奖失败，可以再次尝试
    public static final int ExchangeStatusOverdue = HdtoolOrdersExceptionDto.ExchangeStatusOverdue;      // 未领取，过期

    /**
     * 必填
     */
    private Long appId;

    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 起始时间
     */
    private Date begin;
    /**
     * 结束时间
     */
    private Date end;
    /**
     * 兑换记录状态，为null默认查询待领取、失败、失效3种状态
     */
    private Integer exchangeStatus;
    /**
     * 奖项类型：奖项id，为null查询所有
     */
    private Long prizeId;
    /**
     * app用户id
     */
    private String partnerUserId;
    /**
     * 页码
     */
    private int rowId;

    /**
     * 每页展示条数
     */
    private int pageSize;


    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Date getBegin() {
        return begin;
    }

    public void setBegin(Date begin) {
        this.begin = begin;
    }

    public Date getEnd() {
        return end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public Integer getExchangeStatus() {
        return exchangeStatus;
    }

    public void setExchangeStatus(Integer exchangeStatus) {
        this.exchangeStatus = exchangeStatus;
    }

    public Long getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public int getRowId() {
        return rowId;
    }

    public void setRowId(int rowId) {
        this.rowId = rowId;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("HdtoolOrdersExceptionQueryDto{");
        sb.append("appId=").append(appId);
        sb.append(", activityId=").append(activityId);
        sb.append(", begin=").append(begin);
        sb.append(", end=").append(end);
        sb.append(", exchangeStatus=").append(exchangeStatus);
        sb.append(", prizeId=").append(prizeId);
        sb.append(", partnerUserId='").append(partnerUserId).append('\'');
        sb.append(", rowId=").append(rowId);
        sb.append(", pageSize=").append(pageSize);
        sb.append('}');
        return sb.toString();
    }
}
