package cn.com.duiba.activity.center.api.enums.equity;

import java.util.Objects;

/**
 * @program: activity-center
 * @description: 核销类型枚举类
 * @author: Simba
 * @create: 2019-09-07 16:07
 **/
public enum VerificationTypeEnum {
    ONLINE(1, "线上核销"),
    OFFLINE(2, "线下核销"),
    OFFLINE_STATION(3, "线下网点核销"),
    ;
    private Integer code;
    private String desc;

    VerificationTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static VerificationTypeEnum ofValue(Integer code) {
        for (VerificationTypeEnum verificationTypeEnum : values()) {
            if (Objects.equals(verificationTypeEnum.getCode(), code)) {
                return verificationTypeEnum;
            }
        }
        return null;
    }
}

