package cn.com.duiba.activity.center.api.remoteservice.quizz;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzAppSpecifyDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xuezhaoming on 16/6/14.
 */
@AdvancedFeignClient
public interface RemoteDuibaQuizzAppSpecifyServiceInner {

    /**
     * 
     * findByDuibaQuizzId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaQuizzId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<DuibaQuizzAppSpecifyDto>> findByDuibaQuizzId(Long duibaQuizzId);

    /**
     * 
     * delete:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @since JDK 1.6
     */
    public void delete(Long id);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaQuizzAppSpecify
     * @return
     * @since JDK 1.6
     */
    public DuibaQuizzAppSpecifyDto insert(DuibaQuizzAppSpecifyDto duibaQuizzAppSpecify);

    /**
     * 
     * findByDuibaQuizzAndApp:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaQuizzId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<DuibaQuizzAppSpecifyDto> findByDuibaQuizzAndApp(Long duibaQuizzId, Long appId);

    /**
     * 
     * findByDuibaQuizzsAndApp:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaQuizzIds
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Map<Long, DuibaQuizzAppSpecifyDto>> findByDuibaQuizzsAndApp(List<Long> duibaQuizzIds, Long appId);

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public DubboResult<DuibaQuizzAppSpecifyDto> find(Long id);

    /**
     * 
     * findByQuizzIdAndAppId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param quizzId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public DubboResult<DuibaQuizzAppSpecifyDto> findByQuizzIdAndAppId(Long quizzId, Long appId);
}
