package cn.com.duiba.activity.center.api.remoteservice.hsbc;

import cn.com.duiba.activity.center.api.dto.hsbc.HsbcHdtoolFreeTimesDto;
import cn.com.duiba.activity.center.api.params.hsbc.HsbcFreeTimeQueryParams;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteHsbcHdtoolFreeTimeService {

    /**
     * 根据cid、周期类型查询记录
     *
     * @param params 查询条件
     * @return 免费次数记录
     */
    List<HsbcHdtoolFreeTimesDto> findTaskByCidAndScopeTypes(HsbcFreeTimeQueryParams params);

    /**
     * 根据cid、周期开始、结束时间查询记录
     *
     * @param params 查询条件
     * @return 免费次数记录
     */
    List<HsbcHdtoolFreeTimesDto> findAllByCidAndScopeTimes(HsbcFreeTimeQueryParams params);
}
