package cn.com.duiba.activity.center.api.remoteservice.hsbc;

import cn.com.duiba.activity.center.api.dto.hsbc.HsbcHdtoolTaskRelationDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author sora
 */
@AdvancedFeignClient
public interface RemoteHsbcHdtoolTaskRelationService {
    /**
     * 查找活动下的任务关系
     *
     * @param operatingActivityId 活动Id
     * @return 任务关系
     */
    List<HsbcHdtoolTaskRelationDto> findByOpId(Long operatingActivityId);


    /**
     * 绑定活动工具、汇丰任务
     *
     * @param operatingActivityId 活动id
     * @param hsbcHdtoolTaskRelationDtoList 映射关系
     * @return true: 绑定成功
     */
    boolean bindHdtoolAndTaskRelationship(Long operatingActivityId, List<HsbcHdtoolTaskRelationDto> hsbcHdtoolTaskRelationDtoList);


    /**
     * 查找app下所有的任务关系
     *
     * @param appId 应用Id
     * @return 任务关系
     */
    List<HsbcHdtoolTaskRelationDto> findAllRelationByAppId(Long appId);
}
