/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.params.activitychannel;

import cn.com.duiba.activity.center.api.params.activitychannel.AppChannelParam;
import cn.com.duiba.activity.center.api.params.activitychannel.MiniProgramChannelParam;
import cn.com.duiba.activity.center.api.params.activitychannel.OfficialAccountChannelParam;
import cn.com.duiba.boot.exception.BizException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;

public class ActivityChannelConfigParam
implements Serializable {
    private static final long serialVersionUID = 3393805408780267235L;
    private AppChannelParam app;
    @JSONField(name="oa")
    private OfficialAccountChannelParam officialAccount;
    @JSONField(name="mp")
    private MiniProgramChannelParam miniProgram;

    public void setDefaultAndCheck() throws BizException {
        if (!(this.hasApp() || this.hasOfficialAccount() || this.hasMiniProgram())) {
            throw new BizException("\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6e20\u9053");
        }
        if (this.hasApp()) {
            this.setAppDefault();
            this.app.check();
        }
        if (this.hasOfficialAccount()) {
            this.officialAccount.check();
        }
        if (this.hasMiniProgram()) {
            this.miniProgram.check();
        }
    }

    private void setAppDefault() {
        if (this.app.getShareUrlType() == null) {
            if (this.officialAccount != null) {
                this.app.setShareUrlType(0);
            } else if (this.miniProgram != null) {
                this.app.setShareUrlType(1);
            }
        } else if (this.officialAccount == null && this.miniProgram == null) {
            this.app.setShareUrlType(null);
        } else if (this.miniProgram == null) {
            this.app.setShareUrlType(0);
        } else if (this.officialAccount == null) {
            this.app.setShareUrlType(1);
        }
    }

    public boolean hasApp() {
        return this.app != null && this.app.isSelected();
    }

    public boolean hasOfficialAccount() {
        return this.officialAccount != null && this.officialAccount.isSelected();
    }

    public boolean hasMiniProgram() {
        return this.miniProgram != null && this.miniProgram.isSelected();
    }

    public AppChannelParam getApp() {
        return this.app;
    }

    public void setApp(AppChannelParam app) {
        this.app = app;
    }

    public OfficialAccountChannelParam getOfficialAccount() {
        return this.officialAccount;
    }

    public void setOfficialAccount(OfficialAccountChannelParam officialAccount) {
        this.officialAccount = officialAccount;
    }

    public MiniProgramChannelParam getMiniProgram() {
        return this.miniProgram;
    }

    public void setMiniProgram(MiniProgramChannelParam miniProgram) {
        this.miniProgram = miniProgram;
    }

    public static void main(String[] args) {
        ActivityChannelConfigParam param = new ActivityChannelConfigParam();
        param.setApp(new AppChannelParam());
        param.setOfficialAccount(new OfficialAccountChannelParam());
        param.setMiniProgram(new MiniProgramChannelParam());
        JSONObject json = new JSONObject();
        json.put("channelConfig", (Object)param);
        System.out.println(json.toJSONString());
        json = JSON.parseObject((String)json.toJSONString());
        param = (ActivityChannelConfigParam)json.getObject("channelConfig", param.getClass());
        System.out.println(JSON.toJSONString((Object)param));
    }
}

