package cn.com.duiba.activity.center.api.enums.wanda;

/**
 * 万达分销类型枚举
 * @author zhengzhihao
 */
public enum WandaDisGoodsTypeEnum {
    
    DISTRIBUTOR(0, "分销员分销"),
    GROGGERY(1, "酒店分销");

    private final int code;
    private final String desc;

    WandaDisGoodsTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据 code 获取枚举
     */
    public static WandaDisGoodsTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (WandaDisGoodsTypeEnum type : values()) {
            if (type.getCode() == code) {
                return type;
            }
        }
        return null;
    }

    /**
     * 判断 code 是否有效
     */
    public static boolean isValid(Integer code) {
        return getByCode(code) != null;
    }

    public int getCode() {
        return code;
    }
}