package cn.com.duiba.activity.center.api.dto.activity;

import java.io.Serializable;
import java.util.Date;

/**
 * 营销活动工具中奖记录流水
 * @Author: xuwei
 * @Date: 2020/09/01
 */
public class MarketingHdtoolPrizeRecordDto implements Serializable {

    private static final long serialVersionUID = 5065971287231645717L;

    /**
     * 奖品状态-未领取
     */
    public static final int STATUS_INIT = 0;
    /**
     * 奖品状态-领取成功
     */
    public static final int STATUS_SUCCESS = 1;
    /**
     * 奖品状态-领取失败
     */
    public static final int STATUS_FAILED = 2;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动类型
     */
    private Integer activityType;

    /**
     * 用户ID
     */
    private Long consumerId;

    /**
     * 商品ID
     */
    private Long appItemId;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 奖品类型
     */
    private String prizeType;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品扩展值（面额、券码等）
     */
    private String prizeValue;

    /**
     * 奖品状态 0:待领取 1:领取成功 2:领取失败
     */
    private Integer prizeStatus;

    /**
     * 主订单ID
     */
    private Long hdtoolOrderId;


    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType == null ? null : prizeType.trim();
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName == null ? null : prizeName.trim();
    }

    public String getPrizeValue() {
        return prizeValue;
    }

    public void setPrizeValue(String prizeValue) {
        this.prizeValue = prizeValue == null ? null : prizeValue.trim();
    }

    public Integer getPrizeStatus() {
        return prizeStatus;
    }

    public void setPrizeStatus(Integer prizeStatus) {
        this.prizeStatus = prizeStatus;
    }

    public Long getHdtoolOrderId() {
        return hdtoolOrderId;
    }

    public void setHdtoolOrderId(Long hdtoolOrderId) {
        this.hdtoolOrderId = hdtoolOrderId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}