package cn.com.duiba.activity.center.api.dto.group;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * @description: 组团活动模型
 * @author: zhengwei
 * @date: 2018-08-08 19:37
 */
public class GroupActivityRecordDto implements Serializable{

    private static final long serialVersionUID = 7269599626428380761L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * appId
     */
    private Long appId;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 团队id
     */
    private String teamId;

    /**
     * 兑吧用户id
     */
    private Long consumerId;

    /**
     * 开发者用户id
     */
    private String partnerId;

    /**
     * 开发者师傅id
     */
    private String parentId;

    /**
     * 徒弟数
     */
    private Long apprenticeNum;

    /**
     * 有效徒弟数
     */
    private Long validApprenticeNum;

    /**
     * 标识用户是否进过兑吧页面
     * {@link cn.com.duiba.activity.center.api.enums.GroupActivityTagEnum}
     */
    private Integer tag;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getTeamId() {
        return teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getPartnerId() {
        return partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Long getApprenticeNum() {
        return apprenticeNum;
    }

    public void setApprenticeNum(Long apprenticeNum) {
        this.apprenticeNum = apprenticeNum;
    }

    public Long getValidApprenticeNum() {
        return validApprenticeNum;
    }

    public void setValidApprenticeNum(Long validApprenticeNum) {
        this.validApprenticeNum = validApprenticeNum;
    }

    public Integer getTag() {
        return tag;
    }

    public void setTag(Integer tag) {
        this.tag = tag;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
