package cn.com.duiba.activity.center.api.remoteservice.hxlc;

import cn.com.duiba.activity.center.api.dto.hxlc.TbHxlcActivityCodeDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
@AdvancedFeignClient
public interface RemoteHxlcActivityCodeService {

    // 1. 批量新增
    int insertBatch(List<TbHxlcActivityCodeDto> codes);

    // 2. 根据条件更新
    int updateByConditions(TbHxlcActivityCodeDto entity);

    // 3. 根据 code 查询
    TbHxlcActivityCodeDto findByCode(String code);

    // 3. 根据 codes 查询
    List<TbHxlcActivityCodeDto> findByCodes(List<String> codes);

    // 4. 根据 gen_phone 和 op_id 查询
    List<TbHxlcActivityCodeDto> findByGenPhoneAndOpId(String genPhone, Long opId);

    // 5. 根据 merchant_name 统计数量
    int countByMerchantNameAndAct(String merchantName,Long opId);
}
