package cn.com.duiba.activity.center.api.remoteservice.wanda;

import cn.com.duiba.activity.center.api.dto.wanda.WandaGoodsActItemDto;
import cn.com.duiba.activity.center.api.dto.wanda.WandaGoodsActItemQueryDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 万达营销活动商品远程服务接口
 * @author Claude
 */
@AdvancedFeignClient
public interface RemoteWandaGoodsActItemService {
    
    /**
     * 批量创建商品
     */
    Boolean batchCreateItems(List<WandaGoodsActItemDto> dtos);

    /**
     * 批量更新商品
     */
    Boolean batchUpdateItems(List<WandaGoodsActItemDto> dtos);

    /**
     * 批量删除商品
     */
    Boolean batchDeleteItems(List<Long> ids);

    /**
     * 分页查询商品列表
     */
    Page<WandaGoodsActItemDto> pageQuery(WandaGoodsActItemQueryDto queryDto);

    /**
     * 根据ID批量查询商品
     * @param ids 商品ID列表
     * @return 商品信息列表
     */
    List<WandaGoodsActItemDto> batchQueryByIds(List<Long> ids);

    /**
     * 根据ID查询商品
     * @param id 商品ID
     * @return 商品信息
     */
    WandaGoodsActItemDto queryById(Long id);

    /**
     * 根据活动ID查询商品列表
     * @param actId 活动ID
     * @return 商品信息列表
     */
    List<WandaGoodsActItemDto> queryByActId(Long actId);
} 