package cn.com.duiba.activity.center.api.enums;

/**
 * @author: LuHui
 * @date: 2024/5/24 18:08
 * @description: cms后台直出奖品状态枚举
 */
public enum CmsSendPrizeStatus {

    /**
     * 初始化
     */
    INIT(0, "初始化"),

    /**
     * 处理中
     */
    PROCESSING(1, "处理中"),

    /**
     * 已完成
     */
    FINISHED(2, "已完成");

    private final int code;
    private final String desc;

    CmsSendPrizeStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static CmsSendPrizeStatus getByCode(int code) {
        for (CmsSendPrizeStatus status : values()) {
            if (status.getCode() == code) {
                return status;
            }
        }
        return null;
    }
}