package cn.com.duiba.activity.center.api.enums.alipayactivityredpack;

import java.util.Objects;

/**
 * @author cjw
 * @version 1.0.0
 * @ClassName DrawStatus.java
 * @Description 卡卷状态
 * @createTime 2022年11月19日 16:47:00
 */
public enum DrawStatusEnum {

    DRAW_STATUS_NORMAL(0, "正常"),
    DRAW_STATUS_MANUAL_INVALIDATION(1, "手动失效"),
    DRAW_STATUS_AOTOMATIC_END(2, "自动结束"),
    DRAW_STATUS_NORMAL_USED(3, "已领取"),
    DRAW_STATUS_CLAIMED(4, "已使用"),
    DRAW_PROCESSING(5, "处理中"),
    DRAW_FAIL(6, "领取失败"),
    ;

    private Integer code;
    private String status;

    public String getStatus() {
        return status;
    }

    public Integer getCode() {
        return code;
    }

    DrawStatusEnum(Integer code, String status) {
        this.code = code;
        this.status = status;
    }

    public static DrawStatusEnum ofValue(Integer code) {
        for (DrawStatusEnum drawStatusEnum : values()) {
            if (Objects.equals(drawStatusEnum.getCode(), code)) {
                return drawStatusEnum;
            }
        }
        return null;
    }
}
