package cn.com.duiba.activity.center.api.enums.richman;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 大富翁 地点触发事件类型
 * @author 歪大哥😁
 * @date 2020-08-14.
 */
public enum RichManLocationEventEnum {

    // 无事件
    NONE(1, "按兵不动"),

    // 前进
    GO(2, "勇往直前"),

    // 后退
    BACK_OFF(3, "退避三舍"),

    // 随机出奖
    RANDOM_LUCK_DRAW(4, "听天由命"),

    // 终极大奖
    FIRST_COME_FIRST_SERVED_DRAW(5, "捷足先登"),

    // 回到起点
    BACK_TO_START(6, "故地重游"),

    ;

    private int code;

    private String desc;

    RichManLocationEventEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    private static Map<Integer, RichManLocationEventEnum> map;

    static {
        Map<Integer, RichManLocationEventEnum> temp = Maps.newHashMap();

        for (RichManLocationEventEnum value : values()) {
            temp.put(value.code, value);
        }
        map = temp;
    }

    public static RichManLocationEventEnum getByCode(Integer code) {
        return map.get(code);
    }

}
