package cn.com.duiba.activity.center.api.dto.elasticgifts;

import java.io.Serializable;

/**
 * app 关系保存结果
 */
public class ElasticGiftsAppSaveResultDto implements Serializable {

    private static final long serialVersionUID = 590314135366904134L;

    public static final String APP_NOT_EXIST = "app 不存在";
    public static final String APP_HAS_EXIST = "app 已经参与其他活动";

    private Long appId;

    private Boolean success;

    private String message;

    /**
     *
     * Creates a new instance of ElasticGiftsAppSaveResultDto.
     *
     * @param appId
     * @param success
     * @param message
     */
    public ElasticGiftsAppSaveResultDto(Long appId, Boolean success, String message) {
        this.appId = appId;
        this.success = success;
        this.message = message;
    }

    /**
     *
     * Creates a new instance of ElasticGiftsAppSaveResultDto.
     *
     */
    public ElasticGiftsAppSaveResultDto() {
        super();
    }

    /**
     * 
     * successResult:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public static ElasticGiftsAppSaveResultDto successResult(Long appId) {
        return new ElasticGiftsAppSaveResultDto(appId, true, null);
    }

    /**
     * 
     * failReuslt:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @param message
     * @return
     * @since JDK 1.6
     */
    public static ElasticGiftsAppSaveResultDto failReuslt(Long appId, String message) {
        return new ElasticGiftsAppSaveResultDto(appId, false, message);
    }



    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
