package cn.com.duiba.activity.center.api.dto.ngame;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import cn.com.duiba.activity.center.api.params.NGameInnerJoinRecordDataParam;

import java.util.Date;

/**
 * 游戏中间状态记录
 * Created by hww on 2018/1/24 下午2:29.
 */
public class NGameInnerJoinRecordDto extends BaseDto{

    private static final long serialVersionUID = -2400794864735621194L;

    /** 处理中 */
    public static final int STATUS_PROCESSING = 0;
    /** 处理完成 */
    public static final int STATUS_FINISH = 1;

    /** 主键id */
    private Long id;
    /** 应用id */
    private Long appId;
    /** 游戏id */
    private Long ngameId;
    /** 用户id */
    private Long consumerId;
    /** 游戏子订单 */
    private Long orderId;
    /** 中间状态记录修改次数 */
    private Integer times;
    /** 绝大多数中间态会有分数变化 用于存放分数 */
    private Long score;
    /**
     * 用于保存其余中间态数据 数据库字段长度限制1024
     * @see NGameInnerJoinRecordDataParam
     * */
    private String dynamicData;
    /** 过程记录状态 0:处理中 1:处理完成 */
    private Integer recordStatus;
    /** 删除状态 0:否 1:是 */
    private Integer deleted;
    /** 创建时间 */
    private Date gmtCreate;
    /** 更新时间 */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getNgameId() {
        return ngameId;
    }

    public void setNgameId(Long ngameId) {
        this.ngameId = ngameId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Integer getTimes() {
        return times;
    }

    public void setTimes(Integer times) {
        this.times = times;
    }

    public Long getScore() {
        return score;
    }

    public void setScore(Long score) {
        this.score = score;
    }

    public String getDynamicData() {
        return dynamicData;
    }

    public void setDynamicData(String dynamicData) {
        this.dynamicData = dynamicData;
    }

    public Integer getRecordStatus() {
        return recordStatus;
    }

    public void setRecordStatus(Integer recordStatus) {
        this.recordStatus = recordStatus;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
