package cn.com.duiba.activity.center.api.remoteservice.alipayactivityredpack;

import cn.com.duiba.activity.center.api.dto.alipayactivityredpack.AlipayRepackCardDto;
import cn.com.duiba.activity.center.api.params.alipayactivityredpack.AlipayCouponCardParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * @author cjw
 * @version 1.0.0
 * @ClassName RemoteRepackCard.java
 * @Description 支付宝链接券-卡券
 * @createTime 2022年11月17日 18:11:00
 */
@AdvancedFeignClient
public interface RemoteRepackCardService {

    /**
     * 存储链接卷
     * @return
     */
    void repackCardSave(List<AlipayRepackCardDto> alipayRepackCardDtos);


    /**
     * 根据短链查询链接卷详情
     * @param shortUrls 短链
     * @return 链接卷信息
     */
    List<AlipayRepackCardDto> findRepackCardInfoByUrl(List<String> shortUrls);

    /**
     * 根据条件查询卡券信息
     * @param alipayRepackCardDto
     * @return
     */
    List<AlipayRepackCardDto> queryByConditions(AlipayRepackCardDto alipayRepackCardDto);

    /**
     * 获取该活动下的链接卷的状态映射
     * @return map key-url value-state
     */
    Map<String, Integer> getUrlAndState(String redpackActivityId);

    /**
     * 获取该活动下的链接卷信息
     * @param redpackActivityId
     * @return
     */
    List<AlipayRepackCardDto> getRepackCardInfoByActivityId(String redpackActivityId);


    /**
     * 根据短链修改链接卷信息
     * @param alipayRepackCardDto
     * @return
     */
    int updateByUrl( AlipayRepackCardDto alipayRepackCardDto);

    /**
     * 根据id修改链接卷信息
     * @param alipayRepackCardDto
     * @return
     */
    int updateById(AlipayRepackCardDto alipayRepackCardDto);

    /**
     * 统计该活动下已领取的卡卷数量
     * @param redpackActivityIds
     * @return
     */
    Map<String,Integer> repackCardUsedCount(List<String> redpackActivityIds, Long batchId);

    /**
     * 统计该活动下已使用卡卷数量
     * @param redpackActivityIds
     * @return
     */
    Map<String,Integer> repackCardverificationCount(List<String> redpackActivityIds, Long batchId);


    /**
     * 分页查询卡券列表
     * @param alipayActivityConfigPageParam
     * @return
     */
    Page<AlipayRepackCardDto> pageByParams(AlipayCouponCardParam alipayActivityConfigPageParam);

    /**
     * 根据id批量修改
     * @param alipayRepackCardDtos
     * @return
     */
    int updateByIds(List<AlipayRepackCardDto> alipayRepackCardDtos);

}
