package cn.com.duiba.activity.center.api.remoteservice.equitycard;

import cn.com.duiba.activity.center.api.dto.equitycard.EquityCardCreateOrderPreInfoDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangdaqing
 * @Description权益卡订单校验
 * @date 2023/9/18 14:16
 */
@AdvancedFeignClient
public interface RemoteEquityCardOrderCheckService {
    /**
     * 根据appId 和活动id，appItemId 判断商品是是否是权益卡的商品以及是否可以购买
     *
     * @param appId
     * @param activityId
     * @param appItemId
     * @return {@link EquityCardCreateOrderPreInfoDto}
     */
    EquityCardCreateOrderPreInfoDto getEquityCardCreateOrderPreInfo(Long appId, Long activityId, Long appItemId,String userId);
}
