package cn.com.duiba.activity.center.api.remoteservice.wanda;

import cn.com.duiba.activity.center.api.dto.wanda.WandaTaxClassifyDto;
import cn.com.duiba.activity.center.api.dto.wanda.WandaTaxClassifyQueryDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 万达税务分类远程服务接口
 * @author Lingma
 */
@AdvancedFeignClient
public interface RemoteWandaTaxClassifyService {

    /**
     * 批量创建税务分类
     */
    Boolean batchCreateTaxClassify(List<WandaTaxClassifyDto> dtos);

    /**
     * 分页查询税务分类列表
     */
    List<WandaTaxClassifyDto> pageQueryTaxClassify(WandaTaxClassifyQueryDto queryDto);

    /**
     * 根据ID查询税务分类
     */
    WandaTaxClassifyDto queryTaxClassifyByClassifyId(Long appId,String classifyId);

    /**
     * 更新税务分类
     */
    Boolean updateTaxClassify(WandaTaxClassifyDto dto);

    /**
     * 删除税务分类
     */
    Boolean deleteTaxClassify(Long id);
}