package cn.com.duiba.activity.center.api.dto.wanda;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;

/**
 * 万达税收分类表数据传输对象
 */
@Data
public class WandaTaxClassifyDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 分类ID
     */
    private String classifyId;

    /**
     * 所在层级别 从1开始
     */
    private Integer level;

    /**
     * 父分类的ID，NULL表示顶层分类
     */
    private String parentId;

    /**
     * 分类名称
     */
    private String name;

    /**
     * 税收分类编码
     */
    private String taxCode;

    /**
     * 税率
     */
    private Integer rate;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}