package cn.com.duiba.activity.center.api.enums.alipayactivityredpack;

import java.util.Objects;

/**
 * @version 1.0.0
 * @ClassName DrawStatus.java
 * @Description 卡券核销状态
 * @createTime 2022年11月19日 16:47:00
 */
public enum CouponStatusEnum {
    VERIFICATION(1, "核销"),
    REFUND(2, "退款"),
    ;

    private Integer code;
    private String status;

    public String getStatus() {
        return status;
    }

    public Integer getCode() {
        return code;
    }

    CouponStatusEnum(Integer code, String status) {
        this.code = code;
        this.status = status;
    }

    public static CouponStatusEnum ofValue(Integer code) {
        for (CouponStatusEnum drawStatusEnum : values()) {
            if (Objects.equals(drawStatusEnum.getCode(), code)) {
                return drawStatusEnum;
            }
        }
        return null;
    }
}
