
package cn.com.duiba.activity.center.api.enums.wanda;

/**
 * 活动状态枚举
 */
public enum WandaGoodsActStatusEnum {
    NOT_STARTED(0, "未开始"),
    IN_PROGRESS(1, "进行中"),
    ENDED(2, "已结束"),
    CLOSED(3, "已关闭");

    private final Integer code;
    private final String desc;

    WandaGoodsActStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static WandaGoodsActStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (WandaGoodsActStatusEnum status : values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }
}


