package cn.com.duiba.activity.center.api.params.activitychannel;

import cn.com.duiba.boot.exception.BizException;
import com.alibaba.fastjson.annotation.JSONField;

/**
 * <p>微信公众号渠道配置参数</p>
 * <p>created by Xuwei on 2021/4/12<p>
 **/
public class OfficialAccountChannelParam extends BaseActivityChannelParam {

    private static final long serialVersionUID = 4844542961291154746L;

    /** 是否授权给兑吧 */
    @JSONField(name = "atd")
    private Boolean authorizeToDuiba;
    /** 是否强制用户关注公众号 */
    @JSONField(name = "fuf")
    private Boolean forceUserFollow;

    public Boolean getAuthorizeToDuiba() {
        return authorizeToDuiba;
    }

    public void setAuthorizeToDuiba(Boolean authorizeToDuiba) {
        this.authorizeToDuiba = authorizeToDuiba;
    }

    public Boolean getForceUserFollow() {
        return forceUserFollow;
    }

    public void setForceUserFollow(Boolean forceUserFollow) {
        this.forceUserFollow = forceUserFollow;
    }

    @Override
    protected void checkSelected() throws BizException {
        if (authorizeToDuiba == null) {
            throw new BizException("是否授权给兑吧不能为空");
        }
        if (forceUserFollow == null) {
            throw new BizException("是否强制用户关注公众号不能为空");
        }
    }
}
