package cn.com.duiba.activity.center.api.remoteservice.equity;

import cn.com.duiba.activity.center.api.dto.equity.StationStockRecordDto;
import cn.com.duiba.activity.center.api.request.equity.StationStockRecordRequest;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteStationStockRecordService {

    Integer save(StationStockRecordDto stationStockRecordDto);


    Integer updateById(StationStockRecordDto stationStockRecordDto);


    StationStockRecordDto getById(Long id)  throws BizException;;

    List<StationStockRecordDto> getByStationId(Long stationId)  throws BizException;;

    List<StationStockRecordDto> listByIds(List<Long> ids);

    List<StationStockRecordDto> findByCondition(StationStockRecordRequest stationStockRecordRequest) throws BizException;
}
