package cn.com.duiba.activity.center.api.remoteservice.joingroup;

import cn.com.duiba.activity.center.api.dto.joingroup.JoinGroupRecordDto;
import cn.com.duiba.activity.center.api.params.JoinGroupRecordPageParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @author zhengjianhao
 * @date 18/9/14
 * @description 用户参团记录
 */
@AdvancedFeignClient
public interface RemoteJoinGroupRecordAppService {

	/**
	 * 新增参团记录
	 */
	int add(JoinGroupRecordDto entity);

	/**
	 * 中奖
	 */
	int modifyStatusForWin(Long id, String winOrderNum);

	/**
	 * 根据团id list批量获取各个团的团长
	 */
	List<JoinGroupRecordDto> getOwnersByGroupIds(List<Long> groupInfoIds);

	/**
	 * 按团id批量获取参团记录
	 */
	List<JoinGroupRecordDto> getByGroupId(Long joinGroupInfoId);

	/**
	 * 按团id列表批量获取参团记录
	 */
	List<JoinGroupRecordDto> getByGroupIds(List<Long> joinGroupInfoIds, Integer size);

	/**
	 *按appid、拼团活动配置id、用户id批量获取参团记录
	 * @param joinGroupRecordPageParam 所有入参都必填
	 * @return
	 */
	List<JoinGroupRecordDto> getPageByAppConfigIdAndUserId(JoinGroupRecordPageParam joinGroupRecordPageParam);

	/**
	 * 根据拼团商品id、用户id及是否团长，获取用户在对应拼团商品的参团数量
	 * @param appId 必传
	 * @param joinGroupItemId 必传
	 * @param consumerId 必传
	 * @param ownerType 非必传：不传则包括开团和参团；传1，是团长，代表开团；传2，不是团长，代表参团
	 * @param gmtCreate 非必传：不传则为总共参与次数
	 * @return
	 */
	Integer getCountByItemAndUserIdAndType(Long appId, Long joinGroupItemId, Long consumerId, Integer ownerType, Date gmtCreate);

	/**
	 * 根据拼团商品id、用户id及是否团长，获取用户在对应拼团商品下有没有进行中的团
	 */
	Boolean checkHasUnderWayGroup(Long appId, Long joinGroupItemId, Long consumerId, Integer ownerType);

	/**
	 * 根据团id和用户id获取用户在该团的参与记录
	 * @param groupId
	 * @param consumerId
	 * @return
	 */
	List<JoinGroupRecordDto> getByGroupIdAndConsumerId(Long groupId, Long consumerId);
}
