package cn.com.duiba.activity.center.api.remoteservice.game;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/5/19.
 */
@AdvancedFeignClient
public interface RemoteDuibaQuestionAnswerServiceNew {

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    DuibaQuestionAnswerDto find(Long id);
    /**
     * 
     * findTagById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    String findTagById(Long id);

    /**
     * 
     * findAutoOff:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    List<DuibaQuestionAnswerDto> findAutoOff();

    /**
     * 
     * updateStatus:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param status
     * @return
     * @since JDK 1.6
     */
    int updateStatus(Long id, Integer status);

    /**
     * 
     * findByIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public List<DuibaQuestionAnswerDto> findByIds(List<Long> ids);

    /**
     * 
     * findExtraInfoById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    ActivityExtraInfoDto findExtraInfoById(Long id);

    /**
     * 
     * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    public List<DuibaQuestionAnswerDto> findAllByIds(List<Long> ids);

    /**
     * 
     * findAllQuestion:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public List<AddActivityDto> findAllQuestion(Long appId);

    /**
     * 
     * findByPage:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param offset
     * @param max
     * @return
     * @since JDK 1.6
     */
    public List<DuibaQuestionAnswerDto> findByPage(Integer offset, Integer max);

    /**
     * 
     * findPageCount:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public Long findPageCount();

    /**
     * 
     * findPageCount:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param paramMap
     * @return
     * @since JDK 1.6
     */
    @RequestMapping("/findPageCount1")
    public Long findPageCount(Map<String, Object> paramMap);

    /**
     * 
     * findByPage:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param paramMap
     * @return
     * @since JDK 1.6
     */
    @RequestMapping("/findByPage1")
    List<DuibaQuestionAnswerDto> findByPage(Map<String, Object> paramMap);

    /**
     * 
     * updateStatus:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param status
     * @return
     * @since JDK 1.6
     */
    @RequestMapping("/updateStatus1")
    public int updateStatus(Long id, int status);

    /**
     * 
     * delete:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public int delete(Long id);
    
    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaQuestionAnswerDto
     * @return
     * @since JDK 1.6
     */
    public DuibaQuestionAnswerDto insert(DuibaQuestionAnswerDto duibaQuestionAnswerDto);
    
    /**
     * 
     * update:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaQuestionAnswerDto
     * @return
     * @since JDK 1.6
     */
    public int update(DuibaQuestionAnswerDto duibaQuestionAnswerDto);
    
    /**
     * 
     * updateTagById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param tag
     * @return
     * @since JDK 1.6
     */
    public int updateTagById(Long id, String tag);
    
    /**
     * 
     * updateAutoOffDateNull:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public int updateAutoOffDateNull(Long id);

    /**
     * 
     * updateSwitches:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param switches
     * @since JDK 1.6
     */
    public void updateSwitches(Long id, Long switches);

    /**
     * 
     * updateForEditActivityCategoryId:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param activityCategoryId
     * @return
     * @since JDK 1.6
     */
    public int updateForEditActivityCategoryId(long id,Long activityCategoryId);


    public DubboResult<DuibaQuestionAnswerDto> updateStatusCloseShow(Long questionAnswerId);

    //from DuibaQuestionAnswerServiceImpl
    public DubboResult<Long> addDuibaQuestionAnswerToDeveloper(Long appId, Long duibaQuestionAnswerId, String isPreview);

    //from AdminQuestionAnswerManagerImpl in manager
    public DubboResult<Void> addDuibaQuestionAnswerAppSpecify(Long id, String[] appIds);

    /**
     * from QuestionAnswerCtrl
     * @param id
     * @param status
     */
    public DubboResult<Void> updateBannerAndAppItem(Long id, Integer status);

    //from QuestionAnswerFlowServiceImpl in credits

    public DubboResult<Void> expireOrderProcess(Long questionOrderId);
}
