package cn.com.duiba.activity.center.api.dto.projectx;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * Created by hong
 * time 2022/8/10.
 */
public class HdtoolProjectTemplateDto implements Serializable {
    private static final long serialVersionUID = -110108247001619764L;
    /**
     * id
     */
    private Long   id;
    /**
     * 星速台项目ID
     */
    private String projectId;
    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 开始时间
     */
    private Date   startTime;
    /**
     * 结束时间
     */
    private Date   endTime;
    /**
     * 图片字段，包含banner图、small图、logo等
     */
    private String imageJson;
    /**
     * 项目配置数据
     */
    private String attributes;
    /**
     * 0，测试；1，正式
     */
    private Integer templateType;
    /**
     * 0，关闭；1，开启
     */
    private Integer openStatus;
    /**
     * 最后操作人
     */
    private String operator;
    /**
     * 最后操作时间
     */
    private Date operatorTime;
    /**
     * 0正常，1删除
     */
    private Integer deleted;
    /**
     * 创建时间
     * @return
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * @return
     */
    private Date gmtModified;

    /**
     * 缩略图
     */
    private String smallImgNew;
    /**
     * banner图
     */
    private String bannerImgNew;

    public String getSmallImgNew() {
        return smallImgNew;
    }

    public void setSmallImgNew(String smallImgNew) {
        this.smallImgNew = smallImgNew;
    }

    public String getBannerImgNew() {
        return bannerImgNew;
    }

    public void setBannerImgNew(String bannerImgNew) {
        this.bannerImgNew = bannerImgNew;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getImageJson() {
        return imageJson;
    }

    public void setImageJson(String imageJson) {
        if(Objects.isNull(imageJson)){
            return;
        }
            JSONObject jsonObject = JSON.parseObject(imageJson);
            setBannerImgNew(jsonObject.getString("bannerImgNew"));
            setSmallImgNew(jsonObject.getString("smallImgNew"));
        this.imageJson = imageJson;
    }

    public String getAttributes() {
        return attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public Integer getTemplateType() {
        return templateType;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    public Integer getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Integer openStatus) {
        this.openStatus = openStatus;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Date getOperatorTime() {
        return operatorTime;
    }

    public void setOperatorTime(Date operatorTime) {
        this.operatorTime = operatorTime;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
