/**
 * Project Name:activity-center-api
 * File Name:RemoteAppDirectService.java
 * Package Name:cn.com.duiba.activity.center.api.remoteservice.activity
 * Date:2017年1月9日下午7:49:46
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.remoteservice.activity;

import cn.com.duiba.activity.center.api.dto.activity.AppDirectDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Set;

/**
 * ClassName:RemoteAppDirectService <br/>
 * Date:     2017年1月9日 下午7:49:46 <br/>
 * @author   liyang
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteAppDirectService {

    public void insert(AppDirectDto appDirectDto);
    public DubboResult<Long> findByAppId(Long appId);
    /**
     * 删除
     * 同时删除缓存
     * @param appId
     * @return
     */
    DubboResult<Boolean> delete(Long appId);

    /**
     * 根据id批量查询
     * @param ids
     * @return
     */
    DubboResult<Set<Long>> findByAppIds(List<Long> ids);

}

