package cn.com.duiba.activity.center.api.remoteservice.bargain;

import cn.com.duiba.activity.center.api.dto.bargain.BargainOrderDto;
import cn.com.duiba.activity.center.api.params.bargain.BargainOrderParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author: linjianhui
 * @Date: 2018/12/10 09:52
 * @Description: 砍价活动手机端服务
 */
@AdvancedFeignClient
public interface RemoteBargainOrderService {
    /**
     * 获取对应订单
     * @param consumerId 用户id
     * @param goodsId  商品id
     * @param activityId 活动id
     * @return
     */
    BargainOrderDto selectByParams(Long consumerId, Long goodsId, Long activityId);

    /**
     * 根据参数获取是否有超时订单
     * @param consumerId
     * @param goodsId
     * @param activityId
     * @return
     */
    BargainOrderDto selectTimeoutOrder(Long consumerId, Long goodsId, Long activityId);

    /**
     * 检查是否有进行中或成功砍价过的订单
     * @param consumerId
     * @param goodsId  商品id
     * @param activityId
     * @return
     */
    Boolean checkInitOrSuccessOrder(Long consumerId, Long goodsId, Long activityId);

    /**
     * 插入砍价订单
     * @param bargainOrderDto
     * @return
     */
    Long insertBargainOrder(BargainOrderDto bargainOrderDto);

    /**
     * 编辑订单订单砍价金额或订单状态
     * @param orderDto
     * @return
     */
    Integer updateBargainPriceOrStatus(BargainOrderDto orderDto);

    /**
     * 根据参数查询我的砍价订单（分页）
     * @param param
     * @return
     */
    Page<BargainOrderDto> pageByParams(BargainOrderParam param);

    /**
     * 通过订单id查询订单
     * @param orderId
     * @return
     */
    BargainOrderDto findById(Long orderId);

    /**
     * 领取福利商品
     * @param orderId
     * @return
     */
    Boolean receiveItem(Long orderId);

    /**
     * 定时任务，将超时订单改为超时，回滚库存
     */
    void checkBargainOrder();

}
