package cn.com.duiba.activity.center.api.remoteservice.bet;

import cn.com.duiba.activity.center.api.dto.bet.AppGroupRelationDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangruofan
 * @date 2018/05/03
 */
@AdvancedFeignClient
public interface RemoteBackendAppGroupRelationService {
    /**
     * 新增关系
     * @param appGroupRelationDto 关系参数
     * @return key
     * @throws BizException bizException
     */
    Long insert(AppGroupRelationDto appGroupRelationDto) throws BizException;

    /**
     * 批量删除和新增关系
     * @param groupId 活动组id
     * @param appIds appId列表
     * @param adSwitch 广告开关
     * @param adPositions 广告位置
     * @throws BizException bizException
     */
    void batchUpdate(Long groupId, String appIds, Integer adSwitch, String adPositions) throws BizException;

    /**
     * 删除关系
     * @param id key
     * @return 成功数
     * @throws BizException bizException
     */
    Integer delete(Long id) throws BizException;
    /**
     * 分页获取关系列表
     * @param groupId 活动组id
     * @param pageNo pageNo
     * @param pageSize pageSize
     * @return 列表
     */
    Page<AppGroupRelationDto> listByGroupId(Long groupId, Integer pageNo, Integer pageSize);
}
