package cn.com.duiba.activity.center.api.dto.activity;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 预约商品订单表DTO
 * 
 * @author cgq
 * @date 2025-01-19
 */
@Data
public class ReservationProductOrderDto implements Serializable {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 主键ID
     */
    private Long id;
    
    /**
     * 是否删除,1-已删除;0-未删除
     */
    private Integer isDeleted;
    
    /**
     * 创建时间
     */
    private Date gmtCreate;
    
    /**
     * 修改时间
     */
    private Date gmtModified;
    
    /**
     * 订单号
     */
    private String orderNo;
    
    /**
     * 用户id
     */
    private Long consumerId;
    
    /**
     * 抽奖号码
     */
    private Long prizeDrawNumber;
    
    /**
     * 抽奖状态：0 等待抽奖，1 抽奖中 2 中奖 3 未中奖
     */
    private Integer prizeDrawStatus;
    
    /**
     * 商品id
     */
    private Long appItemId;
} 