package cn.com.duiba.activity.center.api.dto.equity;

import cn.com.duiba.activity.center.api.enums.equity.EquitySubTypeEnum;
import cn.com.duiba.activity.center.api.enums.equity.EquityTypeEnum;
import cn.com.duiba.activity.center.api.enums.equity.VerificationTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * @program: activity-all
 * @description: 权益配置
 * @author: Simba
 * @create: 2019-07-05 17:59
 **/
public class EquityConfigDto implements Serializable {

    private static final long serialVersionUID = -1662587828152063394L;

    /**
     * 是否西安中信礼包权益
     */
    public static final int SWITCH_XI_AN_GIFT_PACK = 0;



    private Long id;

    private Long appId;

    /**
     * 名称
     */
    private String name;

    /**
     * 类型：
     *
     * @see EquityTypeEnum
     */
    private Integer type;

    /**
     * 图片
     */
    private String image;

    /**
     * 起始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 关联的商品id
     */
    private String appItemIds;

    /**
     * 是否删除
     */
    private Integer deleted;

    /**
     * 记录创建时间
     */
    private Date gmtCreate;

    /**
     * 记录修改时间
     */
    private Date gmtModified;
    /**
     * 权益code
     */
    private String equityCode;
    /**
     * 权益描述
     */
    private String equityDesc;
    /**
     * 核销类型
     *
     * @see VerificationTypeEnum
     */
    private Integer verificationType;

    /**
     * 核销类型
     *
     * @see EquitySubTypeEnum
     */
    private Integer equitySubType;

    /**
     * 关联的网点ids
     */
    private String stationIds;

    /**
     * 分类关键字
     */
    private String classification;

    /**
     * 是否通兑权益，1：是；0：否
     */
    private Integer generalFlag;

    /**
     * 关联商户ids
     */
    private String merchantIds;

    private Integer customSubTypeSwitch;

    //核销次数
    private Long verificationLimit;

    /**
     * 扩展字段：subScriptText-西安中信权益角标
     */
    private String extraInfo;

    public static class ExtraInfoField implements Serializable{

        private static final long serialVersionUID = -3365296378163025121L;

        /**
         * 权益角标
         */
        private String subscriptText;

        /**
         * 联想跳转链接
         */
        private String lianxiangLink;

        public String getSubscriptText() {
            return subscriptText;
        }

        public void setSubscriptText(String subscriptText) {
            this.subscriptText = subscriptText;
        }

        public String getLianxiangLink() {
            return lianxiangLink;
        }

        public void setLianxiangLink(String lianxiangLink) {
            this.lianxiangLink = lianxiangLink;
        }
    }

    public Long getVerificationLimit() {
        return verificationLimit;
    }

    public void setVerificationLimit(Long verificationLimit) {
        this.verificationLimit = verificationLimit;
    }

    public Integer getCustomSubTypeSwitch() {
        return customSubTypeSwitch;
    }

    public void setCustomSubTypeSwitch(Integer customSubTypeSwitch) {
        this.customSubTypeSwitch = customSubTypeSwitch;
    }

    public Integer getGeneralFlag() {
        return generalFlag;
    }

    public void setGeneralFlag(Integer generalFlag) {
        this.generalFlag = generalFlag;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return type;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public String getAppItemIds() {
        return appItemIds;
    }

    public void setAppItemIds(String appItemIds) {
        this.appItemIds = appItemIds;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public String getEquityCode() {
        return equityCode;
    }

    public void setEquityCode(String equityCode) {
        this.equityCode = equityCode;
    }

    public String getEquityDesc() {
        return equityDesc;
    }

    public void setEquityDesc(String equityDesc) {
        this.equityDesc = equityDesc;
    }

    public Integer getVerificationType() {
        return verificationType;
    }

    public void setVerificationType(Integer verificationType) {
        this.verificationType = verificationType;
    }

    public Integer getEquitySubType() {
        return equitySubType;
    }

    public void setEquitySubType(Integer equitySubType) {
        this.equitySubType = equitySubType;
    }

    public String getStationIds() {
        return stationIds;
    }

    public void setStationIds(String stationIds) {
        this.stationIds = stationIds;
    }


    public String getClassification() {
        return classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public String getMerchantIds() {
        return merchantIds;
    }

    public void setMerchantIds(String merchantIds) {
        this.merchantIds = merchantIds;
    }

    public String getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }
}

