package cn.com.duiba.activity.center.api.remoteservice.hdtool;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by wenqi.huang on 16/5/20.
 */
@AdvancedFeignClient
public interface RemoteHdToolsConfigService {

    //来自HdToolsConfigService from developer

    /**
     * 保存或编辑活动工具奖项
     * from developer
     *
     * @param activityId
     * @param appId
     * @param awards
     * @throws Exception
     */
    public DubboResult<Void> saveOrUpdateHdToolOptions(Long activityId, Long appId, String[] awards);

    /**
     * 大转盘保存或编辑活动工具奖项
     * from developer
     *
     * @param activityId
     * @param appId
     * @param awards
     * @param hundredPercentAwards
     * @throws Exception
     */
    public DubboResult<Void> saveOrUpdateHdToolOptionsWithHundredPercent(Long activityId, Long appId, String[] awards, String[] hundredPercentAwards);

    //来自HdToolsConfigService from manager

    /**
     * 管理后台添加活动工具
     *
     * @param hdToolsId
     * @param awards
     */
    public DubboResult<Void> saveOrUpdateDuibaHdToolOptions(Long hdToolsId, List<String> awards);

    /**
     * 管理后台添加或编辑新活动工具奖项
     *
     * @param hdToolsId
     * @param awards
     */
    public DubboResult<Void> saveOrUpdateDuibaNewHdToolOptions(Long hdToolsId, List<String> awards);

    //from HdToolsConfigService in developer

    /**
     * 保存或编辑活动
     *
     * @param activity
     */
    public DubboResult<OperatingActivityDto> saveOrUpdateHdTool(OperatingActivityDto activity);
}
