package cn.com.duiba.activity.center.api.remoteservice.luckycode;

import cn.com.duiba.activity.center.api.dto.luckycode.LuckyCodeAwardConfigDto;
import cn.com.duiba.api.bo.activity.SyncMsgData;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * 幸运码活动奖品配置service
 * author zhanghuifeng
 * date 2019-03-20-15:51
 */
@AdvancedFeignClient
public interface RemoteLuckyCodeAwardConfigService {

    /**
     * 根据活动ID获取奖品配置信息
     * @param activityId
     * @return
     */
    List<LuckyCodeAwardConfigDto> findByActivityId(Long activityId);

    /**
     * 减奖品数剩余库存
     * @param id
     * @return
     */
    Boolean reduceAwardTotal(Long id);

    /**
     * 增加奖品数剩余库存
     * @param id
     * @return
     */
    Boolean addAwardTotal(Long id);

    /**
     * 批量减奖品数剩余库存
     * @param ids
     * @return
     */
    Boolean batchReduceAwardTotal(List<Long> ids);

    /**
     * 批量增加奖品数剩余库存
     * @param ids
     * @return
     */
    Boolean batchAddAwardTotal(List<Long> ids);

    /**
     * 根据活动奖品配置id集合获取信息
     * @param ids
     * @return
     */
    List<LuckyCodeAwardConfigDto> findByIds(List<Long> ids);

    /**
     * 根据活动ID和日期偏移量查询
     * @param activityId
     * @param dateNum
     * @return
     */
    LuckyCodeAwardConfigDto findByActivityIdAndDateNum(Long activityId, Integer dateNum);

    /**
     * 根据活动ID和偏移量列表查询
     * @param activityId
     * @param dateNums
     * @return 偏移量 - 记录映射表
     */
    Map<Integer, LuckyCodeAwardConfigDto> findByActivityIdAndDateNumsWithMapping(Long activityId, List<Integer> dateNums);


    /**
     * 根据主键ID获取信息
     * @param id
     * @return
     */
    LuckyCodeAwardConfigDto findById(Long id);

    /**
     * 同步商家编码
     * @param syncMsgData 同步数据
     * @return 影响行数
     */
    Integer syncMerchantCoding(SyncMsgData syncMsgData);

}
