package cn.com.duiba.activity.center.api.remoteservice.taskunit;

import cn.com.duiba.activity.center.api.dto.taskunit.TaskUnitInviteGenDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteTaskUnitGenInviteService {
    /**
     * 通过兑吧用户id查找邀请码
     *
     * @param consumerId 兑吧用户id
     * @return -
     */
    TaskUnitInviteGenDto findCodeByConsumerId(Long consumerId);

    /**
     * 通过邀请码查找兑吧用户id
     *
     * @param inviteCode 邀请码
     * @return -
     */
    TaskUnitInviteGenDto findConsumerIdByCode(String inviteCode);

    /**
     * 保存
     *
     * @param taskUnitInviteGenDto dto
     * @return 影响行数
     */
    int save(TaskUnitInviteGenDto taskUnitInviteGenDto);
}
