package cn.com.duiba.activity.center.api.dto.richman;

import cn.com.duiba.activity.center.api.enums.richman.RichManLocationEventEnum;

import java.io.Serializable;

/**
 * 大富翁  地点配置
 * 代表游戏地图上每一个格子
 * @author 歪大哥😁
 * @date 2020-08-14.
 */
public class RichManLocationDto implements Serializable {

    private static final long serialVersionUID = 1572099872738124004L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 入库活动id
     */
    private Long operatingActivityId;

    /**
     * 格子在棋盘中的位置  从1开始计数
     */
    private Integer location;

    /**
     * 到达格子时触发的事件
     * @see RichManLocationEventEnum#getCode()
     */
    private Integer locationEvent;

    /**
     * 如果是发奖事件 则会有发奖配置
     */
    private RichManLocationEventConfigDto eventConfig;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public Integer getLocation() {
        return location;
    }

    public void setLocation(Integer location) {
        this.location = location;
    }

    public Integer getLocationEvent() {
        return locationEvent;
    }

    public void setLocationEvent(Integer locationEvent) {
        this.locationEvent = locationEvent;
    }

    public RichManLocationEventConfigDto getEventConfig() {
        return eventConfig;
    }

    public void setEventConfig(RichManLocationEventConfigDto eventConfig) {
        this.eventConfig = eventConfig;
    }
}
