package cn.com.duiba.activity.center.api.dto.guess;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yansen on 16/7/26.
 */
public class GuessStockConsumeDto implements Serializable{

    public static final String ACTION_PAY = "pay";
    public static final String ACTION_BACK = "back";
    private static final long serialVersionUID = 4542363228472029383L;

    private Long id;
    private Long guessStockId;
    private Long optionId;
    private String bizId;
    private String action;
    private Integer quantity;
    private Long appId;
    private Date gmtCreate;
    private Date gmtModified;

    /**
     * 
     * Creates a new instance of GuessStockConsumeDto.
     *
     */
    public GuessStockConsumeDto() {
        super();
    }

    /**
     * 
     * Creates a new instance of GuessStockConsumeDto.
     *
     * @param id
     */
    public GuessStockConsumeDto(Long id) {
        this.id = id;
        this.gmtModified = new Date();
    }

    /**
     * 
     * Creates a new instance of GuessStockConsumeDto.
     *
     * @param init4insert
     */
    public GuessStockConsumeDto(boolean init4insert) {
        if (init4insert) {
            gmtCreate = new Date();
            gmtModified = new Date();
        }
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getGuessStockId() {
        return guessStockId;
    }

    public void setGuessStockId(Long guessStockId) {
        this.guessStockId = guessStockId;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getOptionId() {
        return optionId;
    }

    public void setOptionId(Long optionId) {
        this.optionId = optionId;
    }

}
