package cn.com.duiba.activity.center.api.remoteservice.duibaactivity;

import cn.com.duiba.activity.center.api.dto.duibaactivity.DuibaActivityAppSpecifyDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * 管理员后台专题活动定向
 */
@AdvancedFeignClient
public interface RemoteDuibaActivityAppSpecifyService {

    /**
     * 
     * findDuiBaActivitySpecifyDO:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaActivityId
     * @return
     * @since JDK 1.6
     */
    public List<DuibaActivityAppSpecifyDto> findDuiBaActivitySpecifyDO(Long duibaActivityId);

    /**
     * 
     * delete:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @since JDK 1.6
     */
    public void delete(Long id);

    /**
     * 
     * findByDuibaActivityAndApp:(这里用一句话描述这个方法的作用). <br/>
     * 根据duibaActivityId 和 appId来查询定向关系
     * @param duibaActivityId
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public DuibaActivityAppSpecifyDto findByDuibaActivityAndApp(Long duibaActivityId, Long appId);
    
    /**
     * 
     * findByDuibaActivitysAndApp:(这里用一句话描述这个方法的作用). <br/>
     * 根据duibaActivityIds 和 appId来查询定向关系
     * @param duibaActivityIds
     * @param appId
     * @return
     * @since JDK 1.6
     */
    public Map<Long,DuibaActivityAppSpecifyDto> findByDuibaActivitysAndApp(List<Long> duibaActivityIds, Long appId);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaActivityAppSpecifyDO
     * @since JDK 1.6
     */
    public void insert(DuibaActivityAppSpecifyDto duibaActivityAppSpecifyDO);

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public DuibaActivityAppSpecifyDto find(Long id);

}
