package cn.com.duiba.activity.center.api.remoteservice.grantgood;

import cn.com.duiba.activity.center.api.domain.dto.grantgood.GoodsGrantDetailRecordDto;
import java.util.List;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteGoodsGrantDetailRecordService {

	Long save(GoodsGrantDetailRecordDto goodsGrantDetailRecordDto);

    void deleteById(Long id);

    void deleteBatchByIds(List<Long> ids);

    Integer updateById(GoodsGrantDetailRecordDto goodsGrantDetailRecordDto);

    GoodsGrantDetailRecordDto getById(Long id);

    List<GoodsGrantDetailRecordDto> listByIds(List<Long> ids);

    List<GoodsGrantDetailRecordDto> batchSave(List<GoodsGrantDetailRecordDto> goodsGrantDetailRecordDtoList);

    /**
     * 根据发放记录id查询发放详情
     * @param grantId
     * @return
     */
    List<GoodsGrantDetailRecordDto> listByGrantId(Long grantId);

    /**
     * 更新处理中
     * @param id
     * @return
     */
    Boolean updateProcess(Long id);

    /**
     * 批量更新
     * @param goodsGrantDetailRecordDtoList
     */
    Integer batchUpdate(List<GoodsGrantDetailRecordDto> goodsGrantDetailRecordDtoList);

}
