package cn.com.duiba.activity.center.api.remoteservice.jincheng;

import cn.com.duiba.activity.center.api.dto.jincheng.JinchengCreditsRecordDTO;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 金城银行积分发放记录远程服务接口
 * @author trae
 * @date 2024-01-16
 */
@AdvancedFeignClient
public interface RemoteJinchengCreditsRecordService {

    /**
     * 创建积分发放记录
     * @param recordDto 记录DTO
     * @return 主键ID
     */
    Long createRecord(JinchengCreditsRecordDTO recordDto);

    /**
     * 更新记录状态
     * @param id 主键ID
     * @param status 状态
     * @return 是否更新成功
     */
    Boolean updateStatus(Long id, Integer status);

    /**
     * 根据ID查询记录
     * @param id 主键ID
     * @return 记录DTO
     */
    JinchengCreditsRecordDTO getById(Long id);

    /**
     * 根据第三方单号查询记录
     * @param orderNum 第三方单号
     * @return 记录DTO
     */
    JinchengCreditsRecordDTO getByOrderNum(String orderNum);

    /**
     * 根据appId和uid查询记录列表
     * @param appId 应用ID
     * @param uid 用户ID
     * @param status 发放状态
     * @return 记录DTO列表
     */
    List<JinchengCreditsRecordDTO> listByAppIdAndUid(Long appId, String uid,Integer status);
}